/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleInteger;

/**
 *	Superclass of integer expressions.
 *	
 */
public abstract class IntegerExpression extends Expression
{
    // redefined above the abstracted evalAsInteger
    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new SingleInteger( evalAsInteger( focus, context ) );
    }

    public abstract long evalAsInteger( Focus focus, EvalContext context) throws XQueryException;

} // end of class IntExpression
