/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class NodeComparison: 
 * 
 */
public abstract class NodeComparison extends BooleanExpression {

    public Expression  expr1;
    public Expression  expr2;

    public NodeComparison( Expression expr1, Expression expr2 ) {
        this.expr1 = expr1;
	this.expr2 = expr2;
    }

    public void dump( ExprDump d ) {
	d.header( this, getClass().getName() );
        d.display("node1", expr1);
        d.display("node2", expr2);
    }

    public boolean visit(Visitor v) {
	return v.examine(this) && expr1.visit(v) && expr2.visit(v);
    }

    public Expression staticCheck( StaticContext context ) {
	expr1 = context.staticCheck( expr1, 0 );
	context.checkType(expr1, Type.NODE.opt, "operand1");
	expr2 = context.staticCheck( expr2, 0 );
	context.checkType(expr2, Type.NODE.opt, "operand2");
        type = Type.BOOLEAN;
	return this;
    }
}
