/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.IntegerValue;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 * Representation of integer range x to y.
 */
public class RangeExpr extends Expression {

    public Expression  expr1;
    public Expression  expr2;

    public RangeExpr( Expression expr1, Expression expr2 ) {
        this.expr1 = expr1;
        this.expr2 = expr2;
    }

    public boolean visit(Visitor v) {
	return v.examine(this) && expr1.visit(v) && expr2.visit(v);
    }

    public void dump( ExprDump d ) {
	d.header( this, "RangeExpr" );
        d.display("expr1", expr1);
        d.display("expr2", expr2);
    }

    static Prototype proto = Prototype.op("to", Type.INTEGER.star, RangeExpr.class)
	.arg("from", Type.INTEGER)
	.arg("to", Type.INTEGER);

    public Expression staticCheck( StaticContext context ) {
	context.check(proto, 0, expr1 = context.staticCheck( expr1, 0 ));
	context.check(proto, 1, expr2 = context.staticCheck( expr2, 0 ));
	type = proto.returnType;
	//type = context.check(proto, new Expression[] { expr1, expr2 });
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new Sequence( expr1.evalAsInteger(focus, context),
			     expr2.evalAsInteger(focus, context) );
    }

    static class Sequence extends IntegerValue {
	long start, end;
	long current;

	Sequence( long start, long end ) {
	    
	    this.start = start;
	    this.end = end;
	    if(start <= end)
		 current = start - 1;
	    else current = start + 1;
	}

	public boolean  next() {
	    // NOV 2003
//	    if(start <= end)
		 return (++ current <= end);
//	    else return (-- current >= end);
	}

	public Value  bornAgain() {
	    return new Sequence( start, end );
	}

	public boolean notWorthExpanding() {
	    return true;
	}

	public long  asInteger() {
	    return current;
	}
    }
}
