/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class VarReference: replaced by GlobalVariable or VarReference.Local
 * 
 */
public class VarReference extends Expression {

    public QName  name;

    public VarReference( QName name ) {
        this.name = name;
    }

    public void dump( ExprDump d ) {
	d.header( this, "VarReference" );
        d.display("name", name);
    }

    public boolean visit(Visitor v) {
	return v.examine(this);
    }

    public Expression staticCheck( StaticContext context ) {
	// is it a local ?
	LocalVariable decl = context.lookforLocalVariable(name);
	if(decl != null)
	    return new Local(decl).atSamePlaceAs(this);
	// is it a global ?
	GlobalVariable global = context.lookforGlobalVariable(name);
	if(global != null)
	    return new Global(global).atSamePlaceAs(this);

	context.getLog().error(module, location, "variable %1 not declared",
			       context.prefixedName(name));
	return this;
    }

    static class Global extends VarReference {

	GlobalVariable address;

	Global( GlobalVariable address ) {
	    super(address.name);
	    this.address = address;
	    this.type = address.getType();
	}

	public void dump( ExprDump d ) {
	    d.header( this, "GlobalRef $"+address.name+" addr "+ address );
	}

	public int getFlags() {
	    return address.getFlags();
// 	    // if single Node: necessarily at same_depth!
// 	    return Type.isRepeatable(type.getOccurrence()) ? 
// 		   0 : (DOCUMENT_ORDER + SAME_DEPTH);
	}

	public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	    try {
		return context.loadGlobal( address );
	    } catch( EvalException e ) {
		return context.error(this, e);
	    }
	}
    }

    static class Local extends VarReference {

	LocalVariable decl;

	Local( LocalVariable decl ) {
	    super(decl.name);
	    this.decl = decl;
	    type = decl.type;
	}

	public void dump( ExprDump d ) {
	    d.header( this, "LocalRef $"+name+" addr "+decl.address );
	}

	public int getFlags() {
	    // if single Node: necessarily at same_depth!
	    return Type.isRepeatable(type.getOccurrence()) ? 
		   0 : (DOCUMENT_ORDER + SAME_DEPTH);
	}

	public Value eval( Focus focus, EvalContext context )
	    throws XQueryException {
	    return context.loadLocal( decl.address );
	}

	public long evalAsInteger( Focus focus, EvalContext context )
	    throws XQueryException {
	    return context.loadLocalInteger( decl.address );
	}

	public double evalAsDouble( Focus focus, EvalContext context )
	    throws XQueryException {
	    return context.loadLocalDouble( decl.address );
	}

	public String evalAsString( Focus focus, EvalContext context )
	    throws XQueryException {
	    return context.loadLocalString( decl.address );
	}

	public Item evalAsItem( Focus focus, EvalContext context )
	    throws XQueryException {
	    return context.loadLocalItem( decl.address );
	}
    }
}
