/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.dm.FulltextQuery;
import net.xfra.qizxopen.util.DefaultWordSifter;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.WordSifter;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public class XfnFulltext
extends Function {
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "fulltext");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, Type.BOOLEAN.opt, class$net$xfra$qizxopen$ext$XfnFulltext$Exec == null ? (class$net$xfra$qizxopen$ext$XfnFulltext$Exec = XfnFulltext.class$("net.xfra.qizxopen.ext.XfnFulltext$Exec")) : class$net$xfra$qizxopen$ext$XfnFulltext$Exec).arg("query", (Type)Type.STRING).arg("context", (Type)Type.NODE.star), new Prototype(qfname, Type.BOOLEAN.opt, class$net$xfra$qizxopen$ext$XfnFulltext$Exec == null ? (class$net$xfra$qizxopen$ext$XfnFulltext$Exec = XfnFulltext.class$("net.xfra.qizxopen.ext.XfnFulltext$Exec")) : class$net$xfra$qizxopen$ext$XfnFulltext$Exec).arg("query", (Type)Type.STRING)};
    static /* synthetic */ Class class$net$xfra$qizxopen$ext$XfnFulltext$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static WordSifter getWordSifter(EvalContext evalContext) {
        WordSifter wordSifter = (WordSifter)evalContext.getProperty("word-sifter");
        return wordSifter != null ? wordSifter : new DefaultWordSifter();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.BoolCall {
        public Expression container;
        FulltextQuery previousCompiled;
        String previousQuery;
        EvalContext previousContext;

        protected synchronized FulltextQuery prepareQuery(String string, EvalContext evalContext, WordSifter wordSifter) throws XQueryException {
            if (evalContext == this.previousContext && string.equals(this.previousQuery)) {
                return this.previousCompiled;
            }
            try {
                if (wordSifter == null) {
                    wordSifter = XfnFulltext.getWordSifter(evalContext);
                }
                this.previousCompiled = FulltextQuery.parseQuery(string, wordSifter);
                this.previousQuery = string;
                this.previousContext = evalContext;
                return this.previousCompiled;
            }
            catch (FulltextQuery.ParseException parseException) {
                evalContext.error(this.args[0], "full-text query error: " + parseException.getMessage());
                return null;
            }
        }

        public FulltextQuery preparedQuery(Focus focus, EvalContext evalContext, WordSifter wordSifter) throws XQueryException {
            if (this.args.length > 1) {
                this.container = this.args[1];
            }
            return this.prepareQuery(this.args[0].evalAsString(focus, evalContext), evalContext, wordSifter);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
            FulltextQuery fulltextQuery = this.preparedQuery(focus, evalContext, null);
            if (this.args.length > 1) {
                Value value = this.args[1].eval(focus, evalContext);
                while (value.next()) {
                    Node node = value.asNode();
                    if (!fulltextQuery.matches(node)) continue;
                    return true;
                }
                return false;
            }
            this.checkFocus(focus, evalContext);
            return fulltextQuery.matches(focus.getItem().asNode());
        }
    }
}

