/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleDouble;

public abstract class DoubleValue
extends BaseValue {
    public DoubleValue() {
        this.itemType = Type.DOUBLE;
    }

    public Item asItem() throws TypeException {
        return new SingleDouble(this.asDouble());
    }

    public boolean asBoolean() throws TypeException {
        double d = this.asDouble();
        return d == d && d != 0.0;
    }

    public long asInteger() throws TypeException {
        return Math.round(this.asDouble());
    }

    public String asString() throws TypeException {
        return Conversion.toString(this.asDouble());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        try {
            Item item = (Item)object;
            return item.getType() == Type.DOUBLE && this.asDouble() == item.asDouble();
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            long l = Double.doubleToLongBits(this.asDouble());
            return (int)(l ^ l >>> 32);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        if (!Type.DOUBLE.accepts(item.getType())) {
            return 2;
        }
        return Util.comparison(this.asDouble() - item.asDouble());
    }
}

