/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import java.text.Collator;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.SingleString;

public abstract class GenericValue
extends BaseValue {
    protected Item item;
    protected boolean lazy = false;

    public ItemType getType() {
        return this.item != null ? this.item.getType() : Type.ITEM;
    }

    public Item asItem() throws TypeException {
        if (this.item == null) {
            System.err.println("null item in " + this);
        }
        return this.item;
    }

    public Item asAtom() throws TypeException {
        if (this.item.isNode()) {
            this.item = new SingleString(this.item.asNode().getStringValue(), Type.UNTYPED_ATOMIC);
        }
        return this.item;
    }

    public boolean asBoolean() throws TypeException {
        return this.item.asBoolean();
    }

    public long asInteger() throws TypeException {
        return this.item.asInteger();
    }

    public BigDecimal asDecimal() throws TypeException {
        return this.item.asDecimal();
    }

    public double asDouble() throws TypeException {
        return this.item.asDouble();
    }

    public String asString() throws TypeException {
        if (this.item == null) {
            System.err.println("null item in " + this);
        }
        return this.item.asString();
    }

    public Node asNode() throws TypeException {
        if (this.item == null) {
            System.err.println("null item in " + this);
            return null;
        }
        return this.item.asNode();
    }

    public boolean isNode() {
        return this.item != null && this.item.isNode();
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        return this.item.compareTo(item, collator, n);
    }

    public boolean equals(Object object) {
        return this.item.equals(object);
    }

    public int hashCode() {
        return this.item == null ? 0 : this.item.hashCode();
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }
}

