/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;

public abstract class StringValue
extends BaseValue {
    public StringValue() {
        this.itemType = Type.STRING;
    }

    public Item asItem() throws TypeException {
        return new SingleString(this.asString(), this.itemType);
    }

    public boolean asBoolean() throws TypeException {
        String string = this.asString();
        return string.length() != 0;
    }

    public long asInteger() throws TypeException {
        return Conversion.toInteger(this.asString());
    }

    public double asDouble() throws TypeException {
        return Conversion.toDouble(this.asString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Item)) {
            return false;
        }
        try {
            return this.asString().equals(((Item)object).asString());
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.asString().hashCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int compare(String string, String string2, Collator collator) {
        int n;
        int n2 = n = collator != null ? collator.compare(string, string2) : string.compareTo(string2);
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        ItemType itemType = item.getType();
        if (itemType != this.getType()) {
            if (Type.UNTYPED_ATOMIC.accepts(this.itemType)) {
                return UntypedAtomicType.comparison(this, item, collator);
            }
            if (!Type.STRING.accepts(item.getType())) {
                return 2;
            }
        }
        return StringValue.compare(this.asString(), item.asString(), collator);
    }
}

