/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.op.Expression;

public class Prototype {
    public QName qname;
    public Type returnType;
    public Class classe;
    public QName[] argNames = new QName[3];
    public Type[] argTypes = new Type[3];
    public int argCnt = 0;
    public boolean vararg = false;
    public boolean hidden = false;

    public Prototype(QName qName, Type type, Class clazz, boolean bl) {
        this.qname = qName;
        this.returnType = type;
        this.classe = clazz;
        this.vararg = bl;
    }

    public Prototype(QName qName, Type type, Class clazz) {
        this(qName, type, clazz, false);
    }

    public static Prototype op(String string, Type type, Class clazz) {
        return new Prototype(QName.get(Namespace.OP, string), type, clazz);
    }

    public static Prototype fn(String string, Type type, Class clazz) {
        return new Prototype(QName.get(Namespace.FN, string), type, clazz);
    }

    public static Prototype varfn(String string, Type type, Class clazz) {
        return new Prototype(QName.get(Namespace.FN, string), type, clazz, true);
    }

    public static Prototype xs(String string, Type type, Class clazz) {
        return new Prototype(QName.get(Namespace.XSD, string), type, clazz);
    }

    public Prototype hidden() {
        this.hidden = true;
        return this;
    }

    public Prototype arg(String string, Type type) {
        return this.arg(QName.get(Namespace.NONE, string), type);
    }

    public Prototype arg(QName qName, Type type) {
        if (this.argCnt >= this.argNames.length) {
            QName[] qNameArray = this.argNames;
            this.argNames = new QName[this.argNames.length + 3];
            System.arraycopy(qNameArray, 0, this.argNames, 0, qNameArray.length);
            Type[] typeArray = this.argTypes;
            this.argTypes = new Type[this.argTypes.length + 3];
            System.arraycopy(typeArray, 0, this.argTypes, 0, typeArray.length);
        }
        this.argNames[this.argCnt] = qName;
        this.argTypes[this.argCnt] = type;
        ++this.argCnt;
        return this;
    }

    public Function.Call newInstance(StaticContext staticContext, Expression[] expressionArray) {
        try {
            Function.Call call = (Function.Call)this.classe.newInstance();
            call.prototype = this;
            call.args = expressionArray;
            return call;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getArgName(int n, StaticContext staticContext) {
        return staticContext.prefixedName(this.argNames[n]);
    }

    public String displayName(StaticContext staticContext) {
        if (this.qname.getNamespace() == Namespace.OP) {
            return "operator " + this.qname.getLocalName();
        }
        return staticContext.prefixedName(this.qname);
    }

    public String toString(EvalContext evalContext) {
        return this.toString(evalContext.getStaticContext());
    }

    public String toString(StaticContext staticContext) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.displayName(staticContext));
        stringBuffer.append(" ( ");
        int n = 0;
        while (n < this.argCnt) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('$');
            stringBuffer.append(staticContext.prefixedName(this.argNames[n]));
            stringBuffer.append(" as ").append(this.argTypes[n].toString(staticContext));
            ++n;
        }
        if (this.vararg) {
            stringBuffer.append("...");
        }
        return stringBuffer.append(" ) as ").append(this.returnType.toString(staticContext)).toString();
    }

    public String toString() {
        String string = NSPrefixMapping.std.convertToPrefix(this.qname.getNamespace());
        String string2 = string == null ? this.qname.toString() : string + ":" + this.qname.getLocalName();
        StringBuffer stringBuffer = new StringBuffer(string2 + "( ");
        int n = 0;
        while (n < this.argCnt) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('$');
            stringBuffer.append(this.argNames[n]).append(" as ").append(this.argTypes[n].toString());
            ++n;
        }
        if (this.vararg) {
            stringBuffer.append("...");
        }
        return stringBuffer.append(" ) as ").append(this.returnType.toString()).toString();
    }

    public boolean check(Expression[] expressionArray) {
        if (!(expressionArray.length == this.argCnt || this.vararg && expressionArray.length >= this.argCnt)) {
            return false;
        }
        int n = 0;
        while (n < this.argCnt) {
            if (!this.checkArg(n, expressionArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkArg(int n, Expression expression) {
        return this.checkArg(n, expression.getType());
    }

    public boolean checkArg(int n, Type type) {
        return this.argTypes[n].accepts(type);
    }
}

