/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import java.util.Vector;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.op.AttributeConstructor;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NamedConstructor;

public class ElementConstructor
extends NamedConstructor {
    public Vector attributes = new Vector();

    public ElementConstructor(Expression expression) {
        super(expression);
    }

    public void addAttribute(AttributeConstructor attributeConstructor) {
        this.attributes.add(attributeConstructor);
    }

    public void putCharacters(char[] cArray, int n, int n2) {
        this.addTextItem(new String(cArray, n, n2));
    }

    public AttributeConstructor getAttribute(int n) {
        return n < 0 || n >= this.attributes.size() ? null : (AttributeConstructor)this.attributes.get(n);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "element-constructor");
        exprDump.display("name", this.name);
        exprDump.display("attributes", this.attributes);
        exprDump.display("contents", this.contents);
    }

    public Expression staticCheck(StaticContext staticContext) {
        super.staticCheck(staticContext);
        int n = 0;
        int n2 = this.attributes.size();
        while (n < n2) {
            this.attributes.set(n, staticContext.staticCheck(this.getAttribute(n), 0));
            ++n;
        }
        this.type = Type.ELEMENT;
        return this;
    }

    public int getFlags() {
        return 12;
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        EventDrivenBuilder eventDrivenBuilder = new EventDrivenBuilder();
        try {
            this.evalAsEvents(eventDrivenBuilder, focus, evalContext);
            return eventDrivenBuilder.crop();
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
            return null;
        }
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        QName qName = this.evalName(xMLEventReceiver, focus, evalContext);
        try {
            xMLEventReceiver.startElement(qName);
            int n = 0;
            while (n < this.attributes.size()) {
                this.getAttribute(n).evalAsEvents(xMLEventReceiver, focus, evalContext);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.contents.length) {
                this.contents[n2].evalAsEvents(xMLEventReceiver, focus, evalContext);
                ++n2;
            }
            xMLEventReceiver.endElement(qName);
        }
        catch (DataModelException dataModelException) {
            evalContext.error((Expression)this, "error in constructor: " + dataModelException.getMessage());
        }
    }
}

