/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.*;

/**
 * Tests a node by node kind, and by name if appropriate. Supports wildcards.
 */
public class BaseNodeTest implements NodeTest {

    /**
     * Tested kind (ELEMENT TEXT PI COMMENT..., or -1 for node())
     */
    public int       kind;      // 
    /**
     * Namespace test: null if not specified (* or *:NCName)
     */
    public Namespace namespace;
    /**
     * Localname test: null if not specified (* or ns:*)
     */
    public String    name;
    /**
     * Accelerator, non-null if non-null namespace and name.
     */
    public QName     qname;
    /**
     *	Builds a node test specifying the node-kind and optionally the name
     *	of nodes to match.
     *	@param kind the node-kind as defined in Node: ELEMENT, ATTRIBUTE, TEXT etc.
     *	@param namespace of the node name. If null, represents the wildcard *:NCName.
     *	@param name local part of node name. If null, represents the wildcard ns:* or *.
     */
    public BaseNodeTest( int kind, Namespace namespace, String name ) {
	this.kind = kind;
	this.namespace = namespace;
	if(name != null)
	    name = name.intern();
	this.name = name;
	if(namespace != null && name != null)
	    qname = QName.get(namespace, name);
    }

    public String toString() {
	return "nodeTest("+ kind +", "+ namespace + ":"+ name +")";
    }

    public int getNodeKind() {
	return kind;
    }

    public boolean staticallyCheckable() {
	return namespace == null && name == null;
    }

    public boolean accepts( int nodeKind, QName nodeName ) {
	if(kind > 0 && kind != nodeKind)
	    return false;
	if(nodeName == null)    // contract of the method
	    return true;
	if(namespace == null && name == null)   // dont care about name
	    return true;        
	if(qname != null)       // simple name
	    return qname == nodeName;
	// nodeName cannot be null
	if(namespace != null)
	    return namespace == nodeName.getNamespace();
	else
	    return name == nodeName.getLocalName();
    }

    public boolean needsNode() { return false; }

    public boolean accepts( Node node ) {
	return accepts(node.getNature(), node.getNodeName());
    }
}
