/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *    SQL-LIKE pattern matching. Similar to Glob pattern but slightly different syntax.
 */
public class LikePattern extends GlobPattern
{
    public LikePattern(String pattern) {
	this(pattern.toCharArray(), pattern.length());
    }

    public LikePattern(char[] pattern, int length) {
	super(null, 0);
	exact = false;
	StringBuffer buf = new StringBuffer(length);
	for(int p = 0; p < length; ++p )
	    switch(pattern[p]) {
		case '%':
		    buf.append('*'); break;
		case '_':
		    buf.append('?'); break;
		case '*':
		    buf.append("\\*"); break;
		case '?':
		    buf.append("\\?"); break;
		default:
		    buf.append(pattern[p]); break;
	    }
	char[] p2 = new char[buf.length()];
	buf.getChars(0, p2.length, p2, 0);
	setPattern(p2, p2.length);
    }
}
