/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util.time;

/**
 *	Representation of a GMonthDay value.
 */
public class GMonthDay extends DateTimeBase
{
    public GMonthDay( int month, int day, int tzSign, int tzHour, int tzMinute )
	throws DateTimeException {
        super( EPOCH, month, day, 0, 0, 0, tzSign, tzHour, tzMinute );
    }

    public GMonthDay( DateTimeBase dt ) throws DateTimeException {
        this( dt.month, dt.day, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseGMonthDay(that);
    }

    public static GMonthDay parseGMonthDay(String s) throws DateTimeException {
	int month;
	int day;
	int[] tz = new int[3];

	if (!s.startsWith("--"))
	    throw new DateTimeException("invalid gMonthDay syntax", s);

	int charCount = s.length();
	int pos = 2;
	if (pos+2 >= charCount || s.charAt(pos+2) != '-')
	    throw new DateTimeException("invalid gMonthDay syntax", s);
	month = parseInt(s, pos, pos+2);
	pos += 3;

	int tzPos = parseTimeZone(s, pos, tz);
	if (tzPos != pos+2)
	    throw new DateTimeException("invalid gMonthDay syntax", s);
	day = parseInt(s, pos, tzPos);

	return new GMonthDay(month, day, tz[0], tz[1], tz[2]);
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();

	buffer.append("--");
	appendPadded( month, 2, buffer);
	buffer.append('-');
	appendPadded( day, 2, buffer);
	appendTimeZone( tzSign, tzHour, tzMinute, buffer);

	return buffer.toString();
    }
}
