/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

/**
 *	Thrown when a empty Value is encountered in a context that cannot handle it.
 *	Can be caught be enclosing expressions that accept empty sequences.
 */
public class EmptyException extends EvalException
{
    public EmptyException( String reason ) {
	super(reason);
    }

    /**
     *	Unique instance.<p>
     *	Throwing a statically built exception is perfectly possible in Java. 
     *  This saves the time needed to copy the call stack into the exception,
     *  at the cost of a meaningless printStackTrace(). But we dont care here,
     *  because this is meant to simplify the handling of optionally empty arguments.
     */
    public static EmptyException allowed() {
	return instance;
	//return new EmptyException("unexpected empty sequence");
    }
    
    /**
     *	Unique instance.
     */
    public static EmptyException instance = new EmptyException("unexpected empty sequence");

} // end of class EmptyException

