/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class DecimalType extends NumericType {

    public String getShortName() {
        return "decimal";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	BigDecimal result;
	try {
	    if((type instanceof StringType) ||
	       Type.UNTYPED_ATOMIC.accepts(type))
		result = Conversion.toDecimal( value.asString() );
	    else if(Type.INTEGER.accepts(type))
		result = new BigDecimal( value.asString() );
	    else if(Type.NUMERIC.accepts(type))
		result = new BigDecimal( value.asDouble() );
	    else
		throw new TypeException("invalid type "+type);
	    if(result.scale() < 1)
		result = result.setScale(1);
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:decimal : "+
				    e.getMessage());
        }
	return new SingleDecimal( result );
    }

    public Value  convertFromObject( Object object ) {
	return new SingleDecimal( (BigDecimal) object );
    }

    public Object convertToObject( Expression expr,
				   Focus focus, EvalContext context )
	throws XQueryException {
	Item v = expr.evalAsItem(focus, context);
	BigDecimal value = ((DecimalValue) v).getValue();
	return value;
    }
}
