/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.*;

/**
 *	Abstract Duration value.
 */
public abstract class DurationValue extends BaseValue
{
    public abstract Duration getValue();

    public Item asItem() {
	return this;
    }

    public String  asString()  throws TypeException {
        return getValue().toString(); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof DurationValue) )
	    return false;
	return getValue().equals( ((DurationValue) that).getValue() );
    }

    public int hashCode() {
	return getValue().hashCode();
    }
    
    public int compareTo( Item that, java.text.Collator c, int implicitTimeZone ) {
	if( !Type.DURATION.accepts( that.getType() ) )
	    return INCOMPARABLE;
	return getValue().compareTo( ((DurationValue) that).getValue() );
    }

} // end of class DurationValue

