/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;

/**
 *	A sequence that stores Float/Double items in an array.
 */
public class FloatArraySequence extends GenericValue
{
    protected double[] items;
    protected int size;
    protected int index = -1;

    public FloatArraySequence( double[] items, int size ) {
        this.items = items;
	this.size = size;
    }

    public FloatArraySequence( float[] items, int size ) {
	double[] ritems = new double[size];
	for(int i = size; --i >= 0; )
	    ritems[i] = items[i];
        this.items = ritems;
	this.size = size;
    }

    public boolean next() throws XQueryException {
	if(++ index >= size)
	    return false;
	item = new SingleDouble(items[index]);	// Hmmm
	return true;
    }

    public Value  bornAgain() {
	return new FloatArraySequence( items, size );
    }

    static double[] unroll(Value value) throws XQueryException {
	double[] items = new double[8];
	int ptr = 1;	// items[0] stores the length
	for(; value.next(); ) {
	    if(ptr >= items.length) {
		double[] old = items;
		items = new double[ old.length * 2 ];
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    items[ptr ++] = value.asDouble();
        }
	items[0] = ptr - 1;
	return items;
    }

    /**
     *	Converts a Value representing a sequence of float into an float array.
     */
    public static float[] expandFloats(Value value) throws XQueryException {
	double[] items = unroll(value);
	int len = (int) items[0];
	float[] ritems = new float[len];
	for(int i = 0; i < len; i++)
	    ritems[i] = (float) items[i + 1];
	return ritems;
    }

    /**
     *	Converts a Value representing a sequence of double into an double array.
     */
    public static double[] expandDoubles(Value value) throws XQueryException {
	double[] items = unroll(value);
	int len = (int) items[0];
	double[] ritems = new double[len];
	System.arraycopy(items, 1, ritems, 0, len);
	return ritems;
    }
} 
