/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class IntegerType extends DecimalType {

    public String getShortName() {
        return "integer";
    }

    protected long upperBound() {
	return Long.MAX_VALUE;
    }

    protected long lowerBound() {
	return Long.MIN_VALUE;
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	long result = 0;
	try {
	    if(Type.STRING.accepts(type))
		result = Conversion.toInteger( value.asString() );
	    else if(Type.INTEGER.accepts(type))
		result = value.asInteger();
	    else if(Type.NUMERIC.accepts(type))
		result = (long) value.asDouble();
	    else
		throw new TypeException("invalid type "+type);
	    if(result < lowerBound() || result > upperBound())
		throw new TypeException("value beyond limits");
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:"+getShortName()+
				    " : "+ e.getMessage());
        }
	return new SingleInteger( result, this );
    }

    public Value  convertFromObject( Object object ) {
	return new SingleInteger( ((Long) object).longValue() );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return new Long(expr.evalAsInteger(focus, context));
    }

    public Value  convertFromArray( Object object ) {
	long[] result = (long[]) object;
	return new IntegerArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return IntegerArraySequence.expandIntegers( value );
    }
}
