/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Abstract Integer value.	
 */
public abstract class IntegerValue extends BaseValue
{
    public IntegerValue() {
	itemType = Type.INTEGER;
    }

    public Item asItem() throws TypeException {
	return new SingleInteger( asInteger(), itemType );
    }

    public boolean asBoolean() throws TypeException {
	return asInteger() != 0;
    }

    public double  asDouble() throws TypeException {
	return asInteger();	// simple promotion
    }

    public float   asFloat() throws TypeException {
	return asInteger();	// simple promotion
    }

    public String  asString()  throws TypeException {
        return Conversion.toString( asInteger() ); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof Item) )
	    return false;
        try {
	    return asInteger() == ((Item) that).asInteger();
        }
        catch (TypeException e) { return false; }
    }

    public int hashCode() {
	try {
	    return (int) asInteger();
        }
        catch (Exception e) { return 0; }	// cannot happen
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone ) throws TypeException {
	if( !Type.DOUBLE.accepts( that.getType() ) )
	    return INCOMPARABLE;
	return Util.comparison( asDouble() - that.asDouble() );
    }
} // end of class IntegerValue

