/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Abstract Date/Time value.
 */
public abstract class MomentValue extends BaseValue
{
    public abstract DateTimeBase getValue();

    public Item asItem() {
	return this;
    }

    public String  asString()  throws TypeException {
        return getValue().toString(); 
    }

    public int hashCode() {
	return getValue().hashCode();
    }
    
    public boolean equals( Object that ) {
	if(! (that instanceof MomentValue) )
	    return false;
	return getValue().equals( ((MomentValue) that).getValue() );
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone )
	throws TypeException {
	DateTimeBase value = getValue();
	if( Type.UNTYPED_ATOMIC.accepts(that.getType()))
	    try {
		return value.compareTo( value.parse(that.asString(), implicitTimeZone) );
	    }
	    catch (Exception e) {
		return INCOMPARABLE;
	    }
	if( getType() != that.getType() )
	    return INCOMPARABLE;
	return value.compareTo( ((MomentValue) that).getValue() );
    }

} // end of class MomentValue
