/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;

/**
 *	Abstract QName value.
 */
public abstract class QNameValue extends BaseValue
{
    public QNameValue() {
	itemType = Type.QNAME;
    }

    public abstract QName getValue();

    public Item asItem() {
	return this;
    }

    public String asString() {
	return "expanded-QName(\""+getValue().getURI() +"\", \""
	    + getValue().getLocalName()+ "\")";
    }

    public boolean equals( Object that ) {
	if(! (that instanceof QNameValue) )
	    return false;
	return getValue() == ((QNameValue) that).getValue();
    }

    public int hashCode() {
	return getValue().hashCode();
    }
    
    public int compareTo( Item that, java.text.Collator collator, int implicitTimeZone ) {
	if( !(that instanceof QNameValue) )
	    return INCOMPARABLE;
	QName q1 = getValue(), q2 = ((QNameValue) that).getValue();
	if(q1 == q2)
	    return 0;	// nice optim!
	int d = StringValue.compare(q1.getURI(), q2.getURI(), null);
	if(d != 0)
	    return d;
	return StringValue.compare(q1.getLocalName(), q2.getLocalName(), null);
    }

} // end of class QNameValue

