/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Binary;
import net.xfra.qizxopen.xquery.*;

/**
 *	Implementation of a single item of type hexBinary or base64Binary.
 */
public class SingleBinary extends BinaryValue
{
    protected Binary value;
    private boolean started = false;

    public SingleBinary( Binary value, ItemType subType ) {
	this.value = value;
	itemType = subType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleBinary(value, itemType);
    }

    public Binary getValue() {
	return value;
    }

} // end of class SingleBinary
