/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Namespace;

import java.util.Enumeration;
import java.util.Vector;
import java.util.ArrayList;

/**
 *	External (Java) object wrapped as extension type xdt:object.
 */
public class WrappedObjectType extends AtomicType
{
    Class classe;

    public WrappedObjectType(Class classe) {
	this.classe = classe;
	parent = Type.ATOM;
    }

    public QName getName() {
	return QName.get(Namespace.XDT, getShortName());
    }

    public String toString() {
	return "xdt:object["+classe.getName()+"]";
    }

    public String getShortName() {
        return "object";
    }

    public boolean accepts( Type valueType ) {
	ItemType type = valueType.getItemType();
	if(!(type instanceof WrappedObjectType) || type == Type.OBJECT)
	    return true;
	WrappedObjectType wotype = (WrappedObjectType) type;
	return classe.isAssignableFrom(wotype.classe);
    }

    public Value  convertFromObject( Object object ) {
	if(object instanceof Item)
	    return new SingleItem( (Item) object );
	return (object == null)? Value.empty : new SingleWrappedObject(object);
    }

    public Object convertToObject( Expression expr,
				   Focus focus, EvalContext context )
	throws XQueryException {
	Item item = expr.evalAsItem(focus, context);
	if(item instanceof StringValue)
	    return item.asString();
	if(item instanceof WrappedObjectValue)
	    return ((WrappedObjectValue) item).getObject();
	return item;
    }

    public Value  convertFromArray( Object object ) {
	if(object instanceof Enumeration)
	    return new ObjectArraySequence((Enumeration) object);
	if(object instanceof ArrayList)
	    return new ObjectArraySequence((ArrayList) object);
	if(object instanceof Vector)
	    return new ObjectArraySequence((Vector) object);
	if(object == null)
	    return Value.empty;
	Object[] result = (Object[]) object;
	return new ObjectArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return ObjectArraySequence.expand( value );
    }
} // end of class WrappedObjectType
