/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:ceiling.
 */
public class Ceiling extends Function {

    static Prototype[] protos = { 
        Prototype.fn("ceiling", Type.DOUBLE.opt, Exec.class)
            .arg("srcval", Type.DOUBLE.opt)
    };

    public Prototype[] getProtos() { return protos; }


    public static class Exec extends Function.DoubleCall {

	public double evalAsDouble( Focus focus, EvalContext context ) throws XQueryException {
            context.at(this);
	    return Math.ceil( args[0].evalAsOptDouble(focus, context) );
        }
    }
}
