/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:escape-uri.
 */
public class EscapeUri extends Function {

    static Prototype[] protos = { 
        Prototype.fn("escape-uri", Type.STRING, Exec.class)
            .arg("uri-part", Type.STRING)  .arg("escape-reserved", Type.BOOLEAN)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
	    String uri = args[0].evalAsOptString(focus, context);
	    boolean escReserved = args[1].evalAsBoolean(focus, context);
            context.at(this);
	    if(uri == null)
		return null;
	    StringBuffer buf = new StringBuffer();
	    Util.escapeURI(uri, escReserved, buf);
	    return buf.toString();
        }
    }
}
