/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleQName;

/**
 *  Implementation of function fn:expanded-QName.
 */
public class ExpandedQName extends Function {

    static Prototype[] protos = { 
        Prototype.fn("expanded-QName", Type.QNAME, Exec.class)
            .arg("paramURI", Type.STRING)
            .arg("paramLocal", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            return new SingleQName( QName.get( args[0].evalAsString(focus, context),
					       args[1].evalAsString(focus, context) ) );
        }
    }
}
