/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;

/**
 *  Implementation of function fn:get-in-scope-namespaces.
 */
public class GetInScopeNamespaces extends Function {

    static Prototype[] protos = { 
        Prototype.fn("get-in-scope-namespaces", Type.STRING.star, Exec.class)
            .arg("element", Type.ELEMENT)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Node n = args[0].evalAsNode(focus, context);
	    return n.getNamespaces(true);	// NOT COMPLIANT but better
        }
    }
}
