/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:input.
 */
public class Input extends Function {

    static Prototype[] protos = { 
        Prototype.fn("input", Type.NODE.star, Exec.class)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    Value in = context.getInput();
	    if(in == null)
		context.error( this, "unspecified input" );
            context.at(this);
	    return in;
        }
    }
}
