/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:insert-before.
 */
public class InsertBefore extends Function {

    static Prototype[] protos = { 
        Prototype.fn("insert-before", Type.ITEM.star, Exec.class)
            .arg("target", Type.ITEM.star)
            .arg("position", Type.INTEGER)
            .arg("inserts", Type.ITEM.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            context.error(this, "not available: can be emulated");
	    return Value.empty;
        }
    }
}
