/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:normalize-unicode.
 */
public class NormalizeUnicode extends Function {

    static Prototype[] protos = { 
        Prototype.fn("normalize-unicode", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.STRING.opt),
        Prototype.fn("normalize-unicode", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.STRING.opt)
            .arg("normalizationForm", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
	    String src = args[0].evalAsOptString(focus, context);
	    String nForm = args.length < 2 ?
		null : args[1].evalAsOptString(focus, context);
            context.at(this);
	    if(nForm != null && !nForm.equals("NFC"))
		context.error(args[1], "Unicode normalization form "+ nForm +" not supported");
	    // otherwise it's dummy! TODO when Java supports it
	    return src == null ? "" : src;
        }
    }
}
