/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:position.
 */
public class Position extends Function {

    static Prototype[] protos = { 
        Prototype.fn("position", Type.INTEGER.opt, Exec.class)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {

        public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    checkFocus(focus, context);
            return focus.getPosition();
        }
    }
}
