/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.Collations;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *  Implementation of function fn:starts-with.
 */
public class StartsWith extends Function {

    static Prototype[] protos = { 
        Prototype.fn("starts-with", Type.BOOLEAN.opt, Exec.class)
            .arg("op1", Type.STRING.opt)
            .arg("op2", Type.STRING.opt),
        Prototype.fn("starts-with", Type.BOOLEAN.opt, Exec.class)
            .arg("op1", Type.STRING.opt)
            .arg("op2", Type.STRING.opt)
            .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
	    String s1 = args[0].evalAsOptString(focus, context);
	    String s2 = args[1].evalAsOptString(focus, context);
	    if(s2 == null || s2.length() == 0)
		return true;
	    if(s1 == null || s1.length() == 0)
		return false;
	    Collator collator = args.length < 3 ? 
		null : context.getCollator(args[2].evalAsString(focus, context));
            context.at(this);
	    return Collations.indexOf(s1, s2, collator) == 0;
        }
    }
}
