/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:substring.
 */
public class Substring extends Function {

    static Prototype[] protos = { 
        Prototype.fn("substring", Type.STRING.opt, Exec.class)
            .arg("sourceString", Type.STRING.opt)
            .arg("startingLoc", Type.DOUBLE),
        Prototype.fn("substring", Type.STRING.opt, Exec.class)
            .arg("sourceString", Type.STRING.opt)
            .arg("startingLoc", Type.DOUBLE)
            .arg("length", Type.DOUBLE)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String s = args[0].evalAsOptString(focus, context);
	    if(s == null)
		return "";	// NOV2003 // return null
	    int start = (int) Math.round(args[1].evalAsDouble(focus, context)) - 1;
	    int end = args.length < 3 ? s.length()
		      : start + (int) Math.round(args[2].evalAsDouble(focus, context));
	    end = Math.max(0, Math.min(s.length(), end));
	    start = Math.max(0, Math.min(end, start));
	    return s.substring(start, end);
        }
    }
}
