/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.PatternExpr;
import net.xfra.qizxopen.xquery.dt.NodeType;

/**
 *   XSLT Template rule: this is actually an extended function...
 */
public class Template extends UserFunction
{
    public int importPrecedence;
    public float priority;
    public Expression match;
    // applicable modes: null for #all
    public TemplateMode[] modes;

    public Template ( Module module, int location ) {
	super(module, location);
    }

    // a template has a single prototype, holding the body
    public Signature makePrototype( QName name ) {
	Signature sig = addPrototype(name);
	sig.returnType = Type.NODE.star;
	return sig;
    }

    public void dump( ExprDump d ) {
	d.println("Template" );
	d.display("proto", protos[0].toString());
	d.display("body", protos[0].body);
    }

} // end of class Template 
