/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

/**
 *  (Non)Implementation of function fn:unordered.
 */
public class Unordered extends Function {

    static Prototype[] protos = { 
        Prototype.fn("unordered", Type.ITEM.star, Exec.class)
	  .arg("op", Type.ITEM.star)
    };
    public Prototype[] getProtos() { return protos; }

    public Expression staticCheck(StaticContext context, Expression[] arguments,
				  Expression subject )
    {
	if(arguments.length != 1)
	    context.error(subject, "function fn:unordered() wants one argument",
			  null, null);
	// bluntly return the argument (ie disappear)
        return context.staticCheck(arguments[0], Expression.UNORDERED);
    }

    // dummy
    public static class Exec extends Function.Call {
        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    return Value.empty;
	}
    }
}
