/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.ReverseArraySequence;

/**
 *  Implementation of path step ancestor:: .
 */
public class AncestorStep extends ReverseStep {

    public AncestorStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "ancestor::" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	Value s = focus.getItem().asNode().getAncestors( nodeTest );
	return naturalStepOrder ? s : new ReverseArraySequence(s);
    }
}
