/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class NamespaceConstructor: used to remember NS on element constructors. 
 */
public class NamespaceConstructor extends AttributeConstructor {

    public NamespaceConstructor( String prefix, String uri ) {
        super( null );
	this.prefix = prefix;
	this.value = uri;
    }

    public NamespaceConstructor( Expression prefix, Expression uri ) {
        super( prefix );
	if(uri != null)
	    addItem(uri);
    }

    public void dump( ExprDump d ) {
	d.header( this, "namespaceConstructor" );
        d.display("name", prefix);
        d.display("uri", value);
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {
	if(prefix != null) {	// direct constructor
	    Node node = CoreDataModel.newNSNode(prefix);
	    node.addText(value);
	    return node;
	}
        QName qname = evalName(null, focus, context);
	Node node = CoreDataModel.newNSNode(qname.getLocalName());
	evalContents( node, focus, context );
	return node;
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException {
	if(prefix != null)	// direct constructor
	    output.namespace(prefix, value);
	else {
	    QName qname = evalName(null, focus, context);
	    output.namespace( qname.getLocalName(), evalContents(focus, context) );
	}
    }
}
