/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import java.util.Vector;

/**
 *  class SequenceExpr: 
 * 
 */
public class SequenceExpr extends Expression {

    Expression[] exprs = new Expression[0];

    public SequenceExpr( ) {
    }

    public void  addExpr( Expression expr ) {
        exprs = addExpr(exprs, expr);
    }

    Expression  getExpr( int rank ) {
        return rank < 0 || rank >= exprs.length ? null : exprs[rank];
    }

    public Expression child(int rank) {
	return (rank < exprs.length)? exprs[rank] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "SequenceExpr" );
        d.display("exprs", exprs);
    }

    public Expression staticCheck( StaticContext context ) {
	type = exprs.length == 0 ? Type.NONE.opt : null;
	for(int e = 0, E = exprs.length; e < E; e++) {
	    exprs[e] = context.staticCheck(exprs[e], 0);
	    if(type == null)
		type = exprs[e].getType();
	    else
		type = type.unionWith( exprs[e].getType() );
	    if(type == null)
		context.getLog().error(exprs[e].module, exprs[e].location, "no union type", "");
	}
	if(exprs.length > 1)
	    type = type.getItemType().star;
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
        return new Sequence( focus, context );
    }
    
    public class Sequence extends GenericValue
    {
	Focus focus;
	EvalContext context;
	Value curComp;
	int   index;

	Sequence( Focus focus, EvalContext context ) {
	    this.focus = focus;
	    this.context = context;
	    curComp = Value.empty;
	    index = -1;
	}

	public boolean next() throws XQueryException {
	    for(;;) {
		if(curComp.next()) {
		    item = curComp.asItem();
		    return true;
		}
		if( ++ index >= exprs.length)
		    return false;
		curComp = getExpr(index ).eval( focus, context );
	    }
	}

	public boolean  nextCollection() throws XQueryException {
	    for(;;) {
		if(curComp.nextCollection()) {
		    item = curComp.asItem();
		    return true;
		}
		if( ++ index >= exprs.length)
		    return false;
		curComp = getExpr(index ).eval( focus, context );
	    }
	}

	public Value  bornAgain() {
	    return new Sequence( focus, context );
	}

    } // end of class Sequence

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context)
	throws XQueryException, DataModelException {
	context.at(this);
	for(int e = 0, E = exprs.length; e < E; e++)
	    exprs[e].evalAsEvents( output, focus, context );
    }
}
