/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.dm.UnionNodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.GenericValue;

/**
 * 
 */
public class UnionOp extends NodeExpression {

    public UnionOp( Expression expr1, Expression expr2 ) {
        super(expr1, expr2);
    }

    public void dump( ExprDump d ) {
	d.header( this, "UnionOp" );
        d.display("expr1", expr1);
        d.display("expr2", expr2);
    }

    public Expression reduce() {
	if(expr1 instanceof UnionOp)
	    expr1 = ((UnionOp) expr1).reduce();
	if(expr2 instanceof UnionOp)
	    expr2 = ((UnionOp) expr2).reduce();
	if( ! (expr1 instanceof ChildStep) || ! (expr2 instanceof ChildStep) )
	    return this;
	// TODO : not only child, but any identical axes
	NodeTest t1 = ((ChildStep) expr1).nodeTest;
	NodeTest t2 = ((ChildStep) expr2).nodeTest;
	return new ChildStep( new UnionNodeTest(t1, t2) ).atSamePlaceAs(this);
    }

    public Expression staticCheck( StaticContext context ) {
	super.staticCheck(context);
	return reduce();
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new Sequence( expr1.eval(focus, context), expr2.eval(focus, context));
    }

    public class Sequence  extends GenericValue
    {
	Value  s1, s2;
	Node n1, n2;	// current nodes

	Sequence( Value s1, Value s2 ) throws XQueryException {
	    this.s1 = s1; this.s2 = s2; 
	    n1 = s1.next() ? s1.asNode() : null;
	    n2 = s2.next() ? s2.asNode() : null;
	}

	// assumes that s1 and s2 are in doc order
	public boolean next() throws XQueryException {

	    // is one sequence finished ?
	    if(n1 == null)
		if(n2 == null)
		    return false;
		else {
		    item = n2;
		    n2 = s2.next() ? s2.asNode() : null;
		    return true;
		}
	    if(n2 == null) {
		item = n1;
		n1 = s1.next() ? s1.asNode() : null;
		return true;
	    }
	    // we have an item in both sequences:
	    int cmp = n1.orderCompare(n2);
	    if(cmp <= 0) {
		item = n1;
		n1 = s1.next() ? s1.asNode() : null;
	    }
	    if(cmp >= 0) {
		item = n2;
		n2 = s2.next() ? s2.asNode() : null;
	    }
	    return true;
	}

	public Value  bornAgain() {
	    try {
		return new Sequence(s1.bornAgain(), s2.bornAgain());
	    } catch(XQueryException e) {
		return null; 	// cannot happen
	    }
	}
    }
}
