/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.api.util.ImportOptions;
import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.ComboSelector;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import com.qizx.apps.studio.gui.Localization;
import com.qizx.apps.studio.gui.TextPort;
import com.qizx.apps.util.QizxConnector;
import com.qizx.util.LikePattern;
import com.qizx.util.StringPattern;
import com.qizx.util.basic.FileCollector;
import com.qizx.util.basic.FileUtil;
import com.qizx.util.basic.PathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Style;

public class ImportDialog
extends DialogBase
implements ListSelectionListener {
    private static final int HSPACE = 8;
    private static Localization local = new Localization(QizxStudio.class, "ImportDialog");
    private static final String IMAGE_EXTS = " jpg jpeg png gif tif tiff ico pbm ";
    private AppFrame app;
    private ImportOptions impOptions = new ImportOptions();
    private boolean nonXML;
    private JButton delFileButton;
    private FileModel fileModel;
    private JTable fileTable;
    private ComboSelector filterCombo;
    private JFileChooser fileChooser;
    private JButton runImport;
    private JProgressBar bar;
    private JTextField currentDoc;
    private JLabel docCountDisplay;
    private JLabel timeDisplay;
    private TextPort messages;
    private Style errorStyle;
    private boolean importCancelled;
    private ImportTask importTask;
    private JPanel optionPanel;
    private JCheckBox optionStripBox;
    private QizxStudio.MemberAction target;
    private QizxConnector connector;

    public ImportDialog(AppFrame appFrame, boolean bl) {
        super((Frame)appFrame, local.text(bl ? "Import_NonXML_Documents" : "Import_Documents"));
        this.nonXML = bl;
        this.app = appFrame;
        this.buildContents();
        this.haveOnlyCloseButton();
        Help.setDialogHelp(this, "import_documents_dialog");
        this.pack();
    }

    public void showUpForImport(QizxStudio.MemberAction memberAction) {
        this.target = memberAction;
        this.connector = memberAction.browser.getConnector();
        if (memberAction.path == null) {
            memberAction.path = "/";
        }
        this.setHint(local.text("Import_into") + " " + memberAction.library + ", collection " + memberAction.path + local.text("hint"), true);
        this.fileModel.clear();
        this.showUp();
    }

    private void buildContents() {
        Object[] objectArray;
        GridBagger gridBagger = new GridBagger(this.form);
        gridBagger.setInsets(0, 8);
        gridBagger.newRow();
        Box box = Box.createHorizontalBox();
        gridBagger.add(box, gridBagger.prop("xfill"));
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(new BasicAction(local.text("Add_File/Folder..."), null, "cmdAddFile", this));
        box.add(jButton);
        GUI.betterLookButton(jButton);
        jButton.setToolTipText(local.text("addFile_tip"));
        box.add(Box.createHorizontalStrut(8));
        this.delFileButton = new JButton(new BasicAction(local.text("Remove"), null, "cmdDelFile", this));
        box.add(this.delFileButton);
        GUI.betterLookButton(this.delFileButton);
        this.delFileButton.setEnabled(false);
        box.add(Box.createHorizontalStrut(8));
        JButton jButton2 = new JButton(new BasicAction(local.text("Clear_all"), null, "cmdClearFiles", this));
        box.add(jButton2);
        GUI.betterLookButton(jButton2);
        if (this.nonXML) {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = "*.*";
        } else {
            String[] stringArray = new String[2];
            stringArray[0] = "*.xml";
            objectArray = stringArray;
            stringArray[1] = "*.*";
        }
        Object[] objectArray3 = objectArray;
        this.filterCombo = new ComboSelector(local.text("Filter") + ":", objectArray3, true);
        box.add(this.filterCombo);
        this.fileChooser = this.app.newFileChooser("import");
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setFileSelectionMode(2);
        gridBagger.newRow();
        this.fileModel = new FileModel();
        this.fileTable = new JTable(this.fileModel);
        this.fileTable.setIntercellSpacing(new Dimension(4, 5));
        TableColumnModel tableColumnModel = this.fileTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(350);
        this.defineColumn(tableColumnModel, 0, 350, 2);
        this.defineColumn(tableColumnModel, 1, 50, 0);
        this.defineColumn(tableColumnModel, 2, 90, 4);
        this.defineColumn(tableColumnModel, 3, 50, 0);
        this.fileTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.fileTable);
        jScrollPane.setPreferredSize(new Dimension(500, 100));
        gridBagger.add(jScrollPane, gridBagger.prop("fill").weighted(1.0, 1.0));
        gridBagger.newRow();
        this.optionPanel = new JPanel();
        this.optionPanel.setBorder(new TitledBorder("Import Options"));
        gridBagger.add(this.optionPanel, gridBagger.prop("xfill"));
        GridBagger gridBagger2 = new GridBagger(this.optionPanel);
        this.optionStripBox = new JCheckBox("Strip Whitespace");
        gridBagger2.add(this.optionStripBox, gridBagger2.prop("left"));
        gridBagger.newRow();
        this.runImport = new JButton(new BasicAction(local.text("Start_import"), "cmdRunImport", this));
        gridBagger.add(this.runImport, gridBagger.prop("center"));
        this.enableImport(true);
        gridBagger.newRow();
        JPanel jPanel = new JPanel();
        gridBagger.add(jPanel, gridBagger.prop("xfill"));
        GridBagger gridBagger3 = new GridBagger(jPanel);
        gridBagger3.newRow();
        this.bar = new JProgressBar(0, 100);
        gridBagger3.add(this.bar, gridBagger3.prop("left"));
        this.bar.setPreferredSize(new Dimension(100, 12));
        this.bar.setMinimumSize(new Dimension(80, 12));
        this.bar.setValue(0);
        this.currentDoc = new JTextField();
        this.currentDoc.setEditable(false);
        gridBagger3.add(this.currentDoc, gridBagger3.prop("xfill").leftMargin(8));
        gridBagger3.newRow();
        this.docCountDisplay = new JLabel("0/0");
        gridBagger3.add(this.docCountDisplay, gridBagger.prop("left"));
        this.timeDisplay = new JLabel("\u00a0");
        gridBagger3.add(this.timeDisplay, gridBagger.prop("left").insets(8, 0));
        gridBagger.newRow();
        this.messages = new TextPort("Messages", -1);
        this.messages.setPreferredSize(new Dimension(500, 120));
        gridBagger.add(this.messages, gridBagger.prop("fill").weighted(1.0, 2.0));
        this.errorStyle = this.messages.addStyle("error", Color.red);
    }

    private void defineColumn(TableColumnModel tableColumnModel, int n, int n2, int n3) {
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setCellRenderer(new AlignedCellRenderer(n3));
    }

    private void enableImport(boolean bl) {
        this.runImport.setText(bl ? "Start Import" : "Cancel");
    }

    private void traceError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImportDialog.this.messages.appendText("*** error " + string + "\n", ImportDialog.this.errorStyle);
            }
        });
    }

    private void clear() {
        this.currentDoc.setText("");
        this.docCountDisplay.setText("\u00a0");
        this.timeDisplay.setText("\u00a0");
        this.bar.setValue(0);
        this.app.waitCursor(false);
        this.importTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdAddFile(ActionEvent actionEvent, BasicAction basicAction) {
        this.fileChooser.setDialogTitle(local.text("fileChooser_title"));
        if (!this.app.showOpenDialog(this.fileChooser, this)) {
            return;
        }
        File[] fileArray = this.fileChooser.getSelectedFiles();
        String string = (String)this.filterCombo.getValue();
        LikePattern likePattern = "*.*".equals(string) || "*".equals(string) ? null : new LikePattern(string);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                FileCollector fileCollector = new FileCollector(fileArray[i], true, (StringPattern)likePattern);
                this.fileModel.addFile(fileCollector);
                this.app.waitCursor(true);
                fileCollector.collect();
                continue;
            }
            finally {
                this.app.waitCursor(false);
            }
        }
    }

    public void cmdDelFile(ActionEvent actionEvent, BasicAction basicAction) {
        int[] nArray = this.fileTable.getSelectedRows();
        int n = nArray.length;
        while (--n >= 0) {
            this.fileModel.removeFile(nArray[n]);
        }
    }

    public void cmdClearFiles(ActionEvent actionEvent, BasicAction basicAction) {
        this.fileModel.clear();
    }

    public void cmdRunImport(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.importTask != null) {
            this.importCancelled = true;
            try {
                this.importTask.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.enableImport(false);
        this.importCancelled = false;
        this.clear();
        this.app.waitCursor(true);
        GUI.paintImmediately(this.currentDoc);
        this.importTask = new ImportTask();
        if (this.importTask.totalFileCount == 0) {
            GUI.warning("Import", "No matching document found");
            this.clear();
            this.enableImport(true);
            return;
        }
        this.messages.appendText("--- Starting import of " + this.importTask.totalFileCount + " document(s) ---\n", null);
        this.bar.setValue(0);
        this.importTask.start();
    }

    private static String guessContentType(String string, File file) {
        String string2 = FileUtil.fileExtension(string);
        if (IMAGE_EXTS.contains(" " + string2.toLowerCase() + " ")) {
            return "image/" + string2;
        }
        if ("pdf".equalsIgnoreCase(string2)) {
            return "application/pdf";
        }
        return "application/octet-stream";
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.delFileButton.setEnabled(this.fileTable.getSelectedRowCount() > 0);
    }

    static class AlignedCellRenderer
    extends DefaultTableCellRenderer {
        int alignment;

        public AlignedCellRenderer(int n) {
            this.alignment = n;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(this.alignment);
            return jLabel;
        }
    }

    static class FileModel
    extends AbstractTableModel {
        ArrayList<FileCollector> fileList = new ArrayList();

        FileModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "file or directory";
                }
                case 1: {
                    return "#files";
                }
                case 2: {
                    return "total size";
                }
                case 3: {
                    return "filter";
                }
            }
            return "?";
        }

        public int getRowCount() {
            return this.fileList.size();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getRow(n).getRoot();
                }
                case 1: {
                    return this.getRow(n).hasDirRoot() ? Long.toString(this.getRow(n).getSize()) : null;
                }
                case 2: {
                    return Long.toString(this.getRow(n).getByteSize());
                }
                case 3: {
                    return this.getRow(n).hasDirRoot() ? this.getRow(n).getFilter() : null;
                }
            }
            return null;
        }

        FileCollector getRow(int n) {
            return this.fileList.get(n);
        }

        public void addFile(FileCollector fileCollector) {
            int n = this.getRowCount();
            this.fileList.add(fileCollector);
            this.fireTableRowsInserted(n, n);
        }

        public void removeFile(int n) {
            this.fileList.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void clear() {
            this.fileList.clear();
            this.fireTableDataChanged();
        }
    }

    class ImportTask
    extends Thread {
        public int totalFileCount;
        public long totalFileSize;
        private double sizeDone;
        private long fileSize;
        private long startTime;
        private int previousEstimation;

        public ImportTask() {
            int n = ImportDialog.this.fileModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                FileCollector fileCollector = ImportDialog.this.fileModel.getRow(i);
                this.totalFileCount += fileCollector.getSize();
                this.totalFileSize += fileCollector.getByteSize();
            }
        }

        public void run() {
            int n;
            long l;
            block20: {
                this.sizeDone = 0.0;
                l = 0L;
                n = 0;
                this.startTime = System.currentTimeMillis();
                String string = ((ImportDialog)ImportDialog.this).target.path;
                this.previousEstimation = Integer.MAX_VALUE;
                try {
                    if (ImportDialog.this.nonXML) {
                        ImportDialog.this.connector.importNonXMLStart(((ImportDialog)ImportDialog.this).target.library);
                    } else {
                        ImportDialog.this.connector.importStart(((ImportDialog)ImportDialog.this).target.library);
                    }
                    int n2 = ImportDialog.this.fileModel.getRowCount();
                    block8: for (int i = 0; i < n2; ++i) {
                        FileCollector fileCollector = ImportDialog.this.fileModel.getRow(i);
                        int n3 = fileCollector.getSize();
                        String string2 = fileCollector.hasDirRoot() ? fileCollector.getRoot().getAbsolutePath() : fileCollector.getRoot().getParent();
                        int n4 = string2.length() + 1;
                        for (int j = 0; j < n3; ++j) {
                            if (ImportDialog.this.importCancelled) break block8;
                            File file = fileCollector.getFile(j);
                            ImportDialog.this.docCountDisplay.setText(j + 1 + "/" + n3 + " files");
                            String string3 = file.getPath();
                            this.fileSize = file.length();
                            ImportDialog.this.currentDoc.setText(string3);
                            ImportDialog.this.currentDoc.select(string3.length(), string3.length());
                            String string4 = string3.substring(n4);
                            String string5 = PathUtil.makePath(string, string4);
                            try {
                                if (ImportDialog.this.nonXML) {
                                    ImportDialog.this.connector.importNonXMLDocument(string5, file, ImportDialog.guessContentType(string4, file));
                                } else {
                                    ImportDialog.this.connector.importDocument(string5, file);
                                }
                                ++n;
                                l += this.fileSize;
                            }
                            catch (QizxConnector.ImportException importException) {
                                for (String string6 : importException.getErrors()) {
                                    if (string6.startsWith("IMPORT ERRORS")) continue;
                                    ImportDialog.this.traceError(string6.replace('\t', ' '));
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                ImportDialog.this.traceError("on document " + file + ": unexpected " + runtimeException);
                                runtimeException.printStackTrace();
                            }
                            catch (Exception exception) {
                                ImportDialog.this.traceError("in document " + file + ": " + exception.getMessage());
                            }
                            this.sizeDone += (double)this.fileSize;
                            this.setBar(this.sizeDone / (double)this.totalFileSize);
                        }
                    }
                    try {
                        if (ImportDialog.this.importCancelled) {
                            ImportDialog.this.connector.rollback(((ImportDialog)ImportDialog.this).target.library);
                            break block20;
                        }
                        ImportDialog.this.currentDoc.setText("Finishing indexing...");
                        ImportDialog.this.timeDisplay.setText("");
                        ImportDialog.this.connector.commit(((ImportDialog)ImportDialog.this).target.library);
                    }
                    catch (Exception exception) {
                        ImportDialog.this.traceError("in commit: " + exception.getMessage());
                        ImportDialog.this.importCancelled = true;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    ImportDialog.this.traceError("fatal " + throwable);
                    ImportDialog.this.importCancelled = true;
                }
            }
            ImportDialog.this.clear();
            ImportDialog.this.enableImport(true);
            if (ImportDialog.this.importCancelled) {
                if (ImportDialog.this.connector.isLocal()) {
                    ImportDialog.this.messages.appendText("*** rolled back ***\n", null);
                } else {
                    ImportDialog.this.messages.appendText("*** import not complete ***\n", null);
                }
            } else {
                long l2 = System.currentTimeMillis() - this.startTime;
                ImportDialog.this.messages.appendText("--- done in " + l2 + " ms ---\n", null);
                int n5 = (int)(l / l2);
                ImportDialog.this.messages.appendText(n + " documents, total size: " + l + ", load speed: " + n5 + " Kb/s\n", null);
                ImportDialog.this.target.refresh();
            }
        }

        void setBar(final double d) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImportDialog.this.bar.setValue((int)Math.rint(100.0 * d));
                }
            });
        }

        public void importProgress(double d) {
            int n;
            double d2 = this.sizeDone + d;
            this.setBar(d2 / (double)this.totalFileSize);
            long l = System.currentTimeMillis() - this.startTime;
            double d3 = d2 / (double)l * 1.05;
            if (l < 1000L) {
                d3 = 2000.0;
            }
            if ((n = (int)(((double)this.totalFileSize - d2) / 1000.0 / d3)) > this.previousEstimation && (double)(n - this.previousEstimation) / (double)n < 0.01) {
                return;
            }
            ImportDialog.this.timeDisplay.setText(n + " seconds remaining");
            this.previousEstimation = n;
        }

        public void commitProgress(double d) {
            this.setBar(d);
        }

        public void backupProgress(double d) {
        }

        public void optimizationProgress(double d) {
        }

        public void reindexingProgress(double d) {
        }
    }
}

