/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class PasswordDialog
extends DialogBase
implements KeyListener {
    private JLabel hintArea;
    private JPasswordField formerPass;
    private JPasswordField newPass1;
    private JPasswordField newPass2;
    private boolean wantFormer;

    public PasswordDialog(Frame frame, String string, String string2, boolean bl) {
        super(frame, string);
        this.wantFormer = bl;
        this.init(string2);
    }

    public PasswordDialog(Dialog dialog, String string, String string2, boolean bl) {
        super(dialog, string);
        this.wantFormer = bl;
        this.init(string2);
    }

    private void init(String string) {
        GridBagger gridBagger = new GridBagger(this.form);
        gridBagger.setInsets(10, 5);
        gridBagger.newRow();
        this.hintArea = new JLabel(string);
        gridBagger.add(this.hintArea, gridBagger.prop("xfill").spans(2, 1));
        if (this.wantFormer) {
            gridBagger.newRow();
            gridBagger.add(new JLabel("Former password: "), gridBagger.prop("right"));
            this.formerPass = new JPasswordField(10);
            gridBagger.add(this.formerPass, gridBagger.prop("xfill"));
        }
        gridBagger.newRow();
        gridBagger.add(new JLabel("New password: "), gridBagger.prop("right"));
        this.newPass1 = new JPasswordField(10);
        gridBagger.add(this.newPass1, gridBagger.prop("xfill"));
        this.newPass1.addActionListener(new BasicAction("", "cmdPass1Entered", this));
        this.newPass1.addKeyListener(this);
        gridBagger.newRow();
        gridBagger.add(new JLabel("Confirm password: "), gridBagger.prop("right"));
        this.newPass2 = new JPasswordField(10);
        gridBagger.add(this.newPass2, gridBagger.prop("xfill"));
        this.newPass2.addActionListener(new BasicAction("", "cmdPass2Entered", this));
        this.newPass2.addKeyListener(this);
        this.getOkButton().setEnabled(false);
        this.pack();
    }

    public char[] getOldPass() {
        if (this.formerPass == null) {
            return null;
        }
        char[] cArray = this.formerPass.getPassword();
        return cArray == null || cArray.length == 0 ? null : cArray;
    }

    public char[] getNewPass() {
        if (this.isCancelled()) {
            return null;
        }
        char[] cArray = this.newPass1.getPassword();
        return cArray == null || cArray.length == 0 ? null : cArray;
    }

    public void cmdEnter(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.getOkButton().isEnabled()) {
            this.cmdOK(actionEvent, basicAction);
        }
    }

    public void cmdPass1Entered(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.newPass2 != null) {
            this.newPass2.grabFocus();
        } else {
            this.cmdEnter(actionEvent, basicAction);
        }
    }

    public void cmdPass2Entered(ActionEvent actionEvent, BasicAction basicAction) {
        this.getOkButton().grabFocus();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.getOkButton().setEnabled(this.equalPasswords());
    }

    private boolean equalPasswords() {
        char[] cArray = this.newPass1.getPassword();
        char[] cArray2 = this.newPass2.getPassword();
        if (cArray == null) {
            return cArray2 == null;
        }
        if (cArray2 == null) {
            return false;
        }
        return Arrays.equals(cArray, cArray2);
    }
}

