/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GridBagger;
import com.qizx.apps.studio.gui.HistoryModel;
import com.qizx.apps.studio.gui.Localization;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerConnectDialog
extends DialogBase
implements ListSelectionListener,
ActionListener {
    private static Localization local = new Localization(QizxStudio.class, "ServerConnectDialog");
    private AppFrame app;
    private HistoryModel recentServers;
    private JTextField urlField;
    private JList recentList;

    public ServerConnectDialog(AppFrame appFrame, HistoryModel historyModel) {
        super((Frame)appFrame, "Connect to Server");
        this.app = appFrame;
        this.recentServers = historyModel;
        this.buildContents();
        Help.setDialogHelp(this, "open_server_dialog");
    }

    public void showUp() {
        this.recentList.clearSelection();
        super.showUp();
    }

    public String getSelected() {
        return this.urlField.getText().trim();
    }

    private void buildContents() {
        this.setHint(local.text("hint"), true);
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.urlField = new JTextField("", 30);
        this.urlField.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.add(this.urlField);
        jPanel.setBorder(new TitledBorder("Qizx Server: "));
        gridBagger.add(jPanel, gridBagger.prop("xfill").spans(2, 1));
        gridBagger.newRow();
        this.recentList = new JList(this.recentServers);
        this.recentList.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.recentList);
        jScrollPane.setBorder(new TitledBorder("Recent Servers: "));
        gridBagger.add(jScrollPane, gridBagger.prop("fill").spans(2, 1).weighted(1.0, 2.0));
        this.recentList.addListSelectionListener(this);
        this.recentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    ServerConnectDialog.this.cmdOK(null, null);
                }
            }
        });
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        String string = this.getSelected();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            super.cmdOK(actionEvent, basicAction);
        }
        catch (Exception exception) {
            this.app.showError(exception);
        }
    }

    public void addRecent(String string) {
        this.recentServers.addItem(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.recentList.getSelectedValue();
        if (string != null) {
            this.urlField.setText(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.urlField) {
            this.cmdOK(actionEvent, null);
        }
    }
}

