/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogUtil;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.MemoryStatus;
import com.qizx.apps.studio.gui.PreferenceKeeper;
import com.qizx.apps.studio.gui.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class AppFrame
extends JFrame {
    protected PreferenceKeeper settings;
    private StatusBar statusBar;
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getName());
    public boolean traceExceptions;

    public AppFrame(String string) {
        super(string);
        this.settings = new PreferenceKeeper(this.getClass());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppFrame.this.commandQuit(null, null);
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        this.statusBar = new StatusBar();
        jPanel.add((Component)this.statusBar, "South");
        this.statusBar.addArea(new MemoryStatus(1000), true);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public String getSetting(String string) {
        return this.settings.get(string);
    }

    public boolean getBoolSetting(String string, boolean bl) {
        return this.settings.getBool(string, bl);
    }

    public int getIntSetting(String string, int n) {
        return this.settings.getInt(string, n);
    }

    public void saveSetting(String string, String string2) {
        this.settings.put(string, string2);
    }

    public void saveSetting(String string, boolean bl) {
        this.settings.put(string, bl);
    }

    public void saveSetting(String string, int n) {
        this.settings.put(string, n);
    }

    protected final void initGlassPane() {
        final Component component = this.getGlassPane();
        component.setCursor(Cursor.getPredefinedCursor(3));
        component.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.redispatchMouseEvent(mouseEvent, true);
            }

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                this.redispatchMouseEvent(mouseWheelEvent, true);
            }

            private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl) {
                Point point = mouseEvent.getPoint();
                Container container = AppFrame.this.getContentPane();
                Point point2 = SwingUtilities.convertPoint(component, point, container);
                Component component2 = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y);
                if (component2 != null) {
                    Point point3 = SwingUtilities.convertPoint(component, point, component2);
                    component2.dispatchEvent(new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){});
        component.addKeyListener(new KeyAdapter(){});
    }

    public void waitCursor(boolean bl) {
        Component component = this.getGlassPane();
        if (bl && !component.isVisible()) {
            component.setVisible(true);
        } else if (!bl && component.isVisible()) {
            component.setVisible(false);
        }
    }

    public ImageIcon getIcon(String string) {
        ImageIcon imageIcon = GUI.getIcon(this.getClass(), "icons/" + string);
        return imageIcon != null ? imageIcon : GUI.getIcon(string);
    }

    protected void fatal(String string) {
        System.err.println("*** " + string);
        System.exit(2);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this, string, this.local("Error"), 0);
    }

    public void showError(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.toString();
        }
        JOptionPane.showMessageDialog(this, string, this.local("Error"), 0);
        if (this.traceExceptions) {
            throwable.printStackTrace();
        }
    }

    public void showError(String string, Throwable throwable) {
        JOptionPane.showMessageDialog(this, string + ": " + throwable.getMessage(), this.local("Error"), 0);
        if (this.traceExceptions) {
            throwable.printStackTrace();
        }
    }

    public boolean confirm(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, this.local("Confirm"), 0);
        return n == 0;
    }

    protected JMenu newMenu(String string) {
        String string2 = this.local(string);
        JMenu jMenu = new JMenu(DialogUtil.buttonLabel(string2));
        char c = DialogUtil.buttonMnemonic(string2);
        if (c != '\u0000') {
            jMenu.setMnemonic(c);
        }
        return jMenu;
    }

    protected JMenuItem addMenuItem(JMenu jMenu, Action action, String string) {
        JMenuItem jMenuItem = new JMenuItem(action);
        if (string != null) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string));
        }
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem addMenuItem(JMenu jMenu, String string, String string2, String string3, String string4, Object object) {
        String string5 = this.local(string2);
        BasicAction basicAction = new BasicAction(DialogUtil.buttonLabel(string5), this.getIcon(string), string4, object);
        JMenuItem jMenuItem = new JMenuItem(basicAction);
        char c = DialogUtil.buttonMnemonic(string5);
        if (c != '\u0000') {
            jMenuItem.setMnemonic(c);
        }
        if (string3 != null) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string3));
        }
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public BasicAction newBasicAction(String string, String string2, Object object, String string3) {
        BasicAction basicAction = new BasicAction(this.local(string), this.getIcon(string2), string3, object);
        return basicAction;
    }

    public String local(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = this.resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return string.replace('_', ' ');
        }
    }

    protected String local(String string, String string2) {
        try {
            String string3 = this.resourceBundle.getString(string);
            return MessageFormat.format(string3, string2);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public JFileChooser newFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        String string2 = "Select_" + string + "_file";
        String string3 = "current_" + string2;
        jFileChooser.setName(string3);
        jFileChooser.setDialogTitle(this.local(string2));
        jFileChooser.setCurrentDirectory(new File(this.settings.get(string3, ".")));
        return jFileChooser;
    }

    public boolean showOpenDialog(JFileChooser jFileChooser, Component component) {
        boolean bl = jFileChooser.showOpenDialog(component) == 0;
        try {
            this.settings.put(jFileChooser.getName(), jFileChooser.getCurrentDirectory().getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    protected abstract boolean readyToQuit();

    public void commandQuit(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.readyToQuit()) {
            System.exit(0);
        }
    }

    public void cmdHelp(ActionEvent actionEvent, BasicAction basicAction) {
        Help.showHelp();
    }

    public void cmdHelpContextual(ActionEvent actionEvent, BasicAction basicAction) {
        Help.contextualHelp(actionEvent.getSource());
    }
}

