/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GUI {
    private static final Insets BUTTON_INSETS = new Insets(2, 4, 1, 4);
    private static final Insets SMALL_INSETS = new Insets(1, 1, 1, 1);
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle(GUI.class.getName());

    public static void nativeLookAndFeel() {
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            if (string.indexOf("GTK") > 0) {
                return;
            }
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String loc(String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return string.replace('_', ' ');
        }
    }

    public static final Component getDialogAnchor(Component component) {
        while (component != null) {
            if (component instanceof Applet || component instanceof Dialog || component instanceof Frame) {
                return component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void setHeader(JScrollPane jScrollPane, JComponent jComponent) {
        JViewport jViewport = new JViewport();
        jViewport.setView(jComponent);
        jScrollPane.setColumnHeader(jViewport);
    }

    public static Font changeSize(Font font, int n) {
        return font.deriveFont((float)font.getSize() + (float)n);
    }

    public static ImageIcon getIcon(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = GUI.class.getResource(string);
        return uRL == null ? null : new ImageIcon(uRL, string);
    }

    public static ImageIcon getIcon(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        return uRL == null ? null : new ImageIcon(uRL, string);
    }

    public static Image getImage(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        return uRL == null ? null : Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public static void bindAction(JComponent jComponent, String string, String string2, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        jComponent.getInputMap(1).put(keyStroke, string2);
        jComponent.getActionMap().put(string2, action);
    }

    public static Action getAction(JComponent jComponent, String string) {
        ActionMap actionMap = jComponent.getActionMap();
        return actionMap != null ? actionMap.get(string) : null;
    }

    public static void paintImmediately(JComponent jComponent) {
        jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public static void notBigger(JComponent jComponent) {
        jComponent.setMaximumSize(jComponent.getPreferredSize());
    }

    public static void notSmaller(JComponent jComponent) {
        jComponent.setMinimumSize(jComponent.getPreferredSize());
    }

    public static void keepMinWidth(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = 2;
        jComponent.setMinimumSize(dimension);
    }

    public static void keepMinHeight(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = 2;
        jComponent.setMinimumSize(dimension);
    }

    public static void setMinWidth(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getMinimumSize();
        if (dimension == null) {
            dimension = new Dimension(n, 0);
        } else {
            dimension.width = n;
        }
        jComponent.setMinimumSize(dimension);
    }

    public static void setMinHeight(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getMinimumSize();
        if (dimension == null) {
            dimension = new Dimension(n, 0);
        } else {
            dimension.height = n;
        }
        jComponent.setMinimumSize(dimension);
    }

    public static void setPreferredWidth(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getPreferredSize();
        if (dimension != null) {
            dimension.width = n;
            jComponent.setPreferredSize(dimension);
        }
    }

    public static void setPreferredHeight(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getPreferredSize();
        if (dimension != null) {
            dimension.height = n;
            jComponent.setPreferredSize(dimension);
        }
    }

    public static int getFontWidth(JComponent jComponent) {
        Font font = jComponent.getFont();
        Graphics2D graphics2D = (Graphics2D)jComponent.getGraphics();
        if (graphics2D == null) {
            return (int)((double)font.getSize() * 0.66);
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = font.getMaxCharBounds(fontRenderContext);
        return (int)(rectangle2D.getWidth() + 0.5);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void waitCursor(JComponent jComponent, boolean bl) {
        jComponent.setCursor(bl ? Cursor.getPredefinedCursor(3) : null);
    }

    public static void alert(String string, String string2) {
        JTextArea jTextArea = new JTextArea(3, 20);
        jTextArea.setOpaque(false);
        jTextArea.setForeground(Color.RED);
        jTextArea.setText(string2);
        jTextArea.setFont(new Font("SansSerif", 1, 12));
        JOptionPane.showMessageDialog(null, jTextArea, string, 0);
    }

    public static void warning(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 2);
    }

    public static void message(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 0);
    }

    public static void error(String string) {
        GUI.message("Error", string);
    }

    public static void error(Throwable throwable) {
        throwable.printStackTrace();
        String string = "<html><pre><b style='color: red;'>" + throwable.getMessage() + "\ntrace:";
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < 20; ++i) {
            string = string + "\n" + stackTraceElementArray[i];
        }
        string = string + "\n...";
        GUI.message("Unexpected error", string);
    }

    public static boolean confirmation(String string, String string2) {
        return JOptionPane.showConfirmDialog(null, string2, string, 0) == 0;
    }

    public static String browseFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        return null;
    }

    public static void iconic(AbstractButton abstractButton) {
        abstractButton.setMargin(SMALL_INSETS);
    }

    public static void betterLookButton(JButton jButton) {
        jButton.setMargin(BUTTON_INSETS);
    }

    public static JButton newBasicButton(String string, String string2, Object object) {
        return new JButton(new BasicAction(string, string2, object));
    }
}

