/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GridBagger
extends GridBagConstraints {
    private JComponent target;
    private boolean rowing;

    public GridBagger(JComponent jComponent) {
        this.target = jComponent;
        jComponent.setLayout(new GridBagLayout());
    }

    public GridBagger(JComponent jComponent, int n, int n2) {
        this.target = jComponent;
        jComponent.setLayout(new GridBagLayout());
        this.insets = new Insets(n2, n, n2, n);
    }

    public void newRow() {
        this.gridx = 0;
        ++this.gridy;
        this.rowing = true;
    }

    public void newColumn() {
        this.gridy = 0;
        ++this.gridx;
        this.rowing = false;
    }

    public void skip(int n) {
        if (this.rowing) {
            this.gridx += n;
        } else {
            this.gridy += n;
        }
    }

    public void add(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = this.gridx;
        gridBagConstraints.gridy = this.gridy;
        this.target.add((Component)jComponent, gridBagConstraints);
        if (this.rowing) {
            this.gridx += gridBagConstraints.gridwidth;
        } else {
            this.gridy += gridBagConstraints.gridheight;
        }
    }

    public void add(JComponent jComponent) {
        this.add(jComponent, this);
    }

    public JLabel addLabel(String string, int n) {
        JLabel jLabel = new JLabel(string);
        if (n != 0) {
            this.add(jLabel, this.prop(n < 0 ? "left" : "right"));
        } else {
            this.add(jLabel);
        }
        return jLabel;
    }

    private GridBagger privateCopy() {
        if (this.target == null) {
            return this;
        }
        GridBagger gridBagger = (GridBagger)this.clone();
        gridBagger.target = null;
        return gridBagger;
    }

    public GridBagger prop(String string) {
        GridBagger gridBagger = this.privateCopy();
        if ("east".equalsIgnoreCase(string) || "right".equalsIgnoreCase(string)) {
            gridBagger.anchor = 13;
        } else if ("center".equalsIgnoreCase(string)) {
            gridBagger.anchor = 10;
        } else if ("west".equalsIgnoreCase(string) || "left".equalsIgnoreCase(string)) {
            gridBagger.anchor = 17;
        } else if ("north".equalsIgnoreCase(string) || "top".equalsIgnoreCase(string)) {
            gridBagger.anchor = 11;
        } else if ("south".equalsIgnoreCase(string) || "bottom".equalsIgnoreCase(string)) {
            gridBagger.anchor = 15;
        } else if ("topleft".equalsIgnoreCase(string)) {
            gridBagger.anchor = 18;
        } else if ("topright".equalsIgnoreCase(string)) {
            gridBagger.anchor = 12;
        } else if ("bottomleft".equalsIgnoreCase(string)) {
            gridBagger.anchor = 16;
        } else if ("bottomright".equalsIgnoreCase(string)) {
            gridBagger.anchor = 14;
        } else if ("xfill".equalsIgnoreCase(string)) {
            gridBagger.fill = 2;
            if (gridBagger.weightx == 0.0) {
                gridBagger.weightx = 1.0;
            }
        } else if ("yfill".equalsIgnoreCase(string)) {
            gridBagger.fill = 3;
            if (gridBagger.weighty == 0.0) {
                gridBagger.weighty = 1.0;
            }
        } else if ("fill".equalsIgnoreCase(string)) {
            gridBagger.fill = 1;
            if (gridBagger.weightx == 0.0) {
                gridBagger.weightx = 1.0;
            }
            if (gridBagger.weighty == 0.0) {
                gridBagger.weighty = 1.0;
            }
        } else {
            throw new IllegalArgumentException("bad property " + string);
        }
        return gridBagger;
    }

    public GridBagger weighted(double d, double d2) {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.weightx = d;
        gridBagger.weighty = d2;
        return gridBagger;
    }

    public GridBagger spans(int n, int n2) {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.gridheight = n2;
        gridBagger.gridwidth = n;
        return gridBagger;
    }

    public GridBagger fullwidth() {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.gridwidth = 0;
        return gridBagger;
    }

    public void setInsets(int n, int n2) {
        this.insets = new Insets(n2, n, n2, n);
    }

    public GridBagger insets(int n, int n2) {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.setInsets(n, n2);
        return gridBagger;
    }

    public GridBagger leftMargin(int n) {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.insets = new Insets(0, n, 0, 0);
        return gridBagger;
    }

    public GridBagConstraints rightMargin(int n) {
        GridBagger gridBagger = this.privateCopy();
        gridBagger.insets = new Insets(0, 0, 0, n);
        return gridBagger;
    }

    public String toString() {
        return "Grid(x=" + this.gridx + ", y=" + this.gridy + ", w=" + this.gridwidth + ", h=" + this.gridheight + ", anchor=" + this.anchor + ", fill=" + this.fill + ", wx=" + this.weightx + ", wy=" + this.weighty + ")";
    }
}

