/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.GUI;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class MemoryStatus
extends Box {
    private static final int MB = 1048076;
    private JProgressBar display;
    Runtime runtime = Runtime.getRuntime();

    public MemoryStatus() {
        this(-1);
    }

    public MemoryStatus(int n) {
        super(0);
        JLabel jLabel = new JLabel("Memory: ");
        Font font = GUI.changeSize(jLabel.getFont(), -2);
        jLabel.setFont(font);
        this.add(jLabel);
        int n2 = (int)(this.runtime.maxMemory() / 1048076L);
        this.display = new JProgressBar(0, n2);
        this.display.setStringPainted(true);
        this.display.setPreferredSize(new Dimension(100, 15));
        this.display.setFont(font);
        this.add(this.display);
        if (n > 0) {
            this.setBeat(n);
        }
    }

    public void displayState() {
        long l = this.runtime.totalMemory();
        long l2 = (l - this.runtime.freeMemory()) / 1048076L;
        int n = (int)(this.runtime.maxMemory() / 1048076L);
        this.display.setValue((int)l2);
        this.display.setString(l2 * 100L / (long)n + "% of " + n + "Mb");
    }

    public void setBeat(int n) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                MemoryStatus.this.displayState();
            }
        };
        new Timer().schedule(timerTask, 0L, (long)n);
    }
}

