/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.ModuleResolver;
import com.qizx.util.basic.Check;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DefaultModuleResolver
implements ModuleResolver {
    private URL base;

    public DefaultModuleResolver(URL uRL) {
        Check.nonNull(uRL, "base URL");
        this.base = uRL;
        if (uRL != null && !uRL.getPath().endsWith("/")) {
            try {
                this.base = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPath() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public URL[] resolve(String string, String[] stringArray) throws MalformedURLException {
        URL uRL = new URL(this.base, string);
        if (this.existingFile(uRL)) {
            return new URL[]{uRL};
        }
        if (stringArray == null || stringArray.length == 0) {
            return new URL[0];
        }
        int n = stringArray.length;
        ArrayList<URL> arrayList = new ArrayList<URL>(n);
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL2 = new URL(this.base, stringArray[i]);
            if (!this.existingFile(uRL2)) continue;
            arrayList.add(uRL2);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public URL getBase() {
        return this.base;
    }

    private boolean existingFile(URL uRL) {
        if (!"file".equals(uRL.getProtocol())) {
            return false;
        }
        File file = new File(uRL.getPath());
        return file.isFile();
    }
}

