/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.fulltext;

import com.qizx.api.fulltext.Scorer;

public class DefaultScorer
implements Scorer {
    public static final String FT_WEIGHT = "ft-weight";
    protected float sumWeight = 0.5f;
    protected int trace = 0;

    public float normalizeScore(float f) {
        float f2 = f / (0.8f + f);
        if (this.trace > 0) {
            System.err.println("== normalize " + f + " => " + f2);
        }
        return f2;
    }

    public float normWord(float f) {
        float f2 = 1.0f + (float)Math.log(f);
        if (this.trace > 0) {
            System.err.println("norm Word: idf= " + 1.0f / f + " -> " + f2);
        }
        return f2;
    }

    public float scoreWord(float f, float f2) {
        float f3 = f * f2;
        if (this.trace > 1) {
            System.err.println("score Word : norm=" + f + " " + f2 + " -> " + f3);
        }
        return f3;
    }

    public float normAll(float[] fArray) {
        if (this.trace > 0) {
            System.err.print("norm All");
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i] * fArray[i];
            if (this.trace <= 0) continue;
            System.err.print(" " + fArray[i]);
        }
        float f2 = (float)(1.0 / Math.sqrt(f));
        if (this.trace > 0) {
            System.err.println(" -> " + f2);
        }
        return f2;
    }

    public float scoreAll(float[] fArray) {
        if (this.trace > 1) {
            System.err.print("score All");
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
            if (this.trace <= 1) continue;
            System.err.print(" " + fArray[i]);
        }
        if (this.trace > 1) {
            System.err.println(" -> " + f);
        }
        return f;
    }

    public float normOr(float[] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
            if (fArray[i] > f2) {
                f2 = fArray[i];
            }
            if (this.trace <= 0) continue;
            System.err.print(" " + fArray[i]);
        }
        float f3 = 1.0f / (this.sumWeight * f + (1.0f - this.sumWeight) * f2);
        if (this.trace > 0) {
            System.err.println("norm Or -> " + f3);
        }
        return f3;
    }

    public float scoreOr(float[] fArray, int n) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
            if (fArray[i] > f2) {
                f2 = fArray[i];
            }
            if (this.trace <= 1) continue;
            System.err.print(" " + fArray[i]);
        }
        float f3 = this.sumWeight * f + (1.0f - this.sumWeight) * f2;
        if (this.trace > 1) {
            System.err.println("score Or -> " + f3);
        }
        return f3;
    }
}

