/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.fulltext;

import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.util.RegexMatchPattern;
import com.qizx.util.basic.IntSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DefaultTextTokenizer
implements TextTokenizer {
    private char[] txt;
    private int txtLength;
    private int ptr;
    private int wordStart;
    private boolean parseSpecialChars;
    private boolean acceptWildCards;
    private int maxDigit = 3;
    private boolean gotWildCard;
    private IntSet specialChars;
    RegexMatchPattern rangePattern;

    public void start(char[] cArray, int n) {
        this.txt = cArray;
        this.txtLength = n;
        this.ptr = 0;
    }

    public void start(CharSequence charSequence) {
        int n = charSequence.length();
        if (charSequence instanceof String) {
            this.txt = ((String)charSequence).toCharArray();
        } else {
            if (this.txt == null || this.txt.length < n) {
                this.txt = new char[n];
            }
            for (int i = 0; i < n; ++i) {
                this.txt[i] = charSequence.charAt(i);
            }
        }
        this.txtLength = n;
        this.ptr = 0;
    }

    public void copyTokenTo(char[] cArray, int n) {
        int n2;
        int n3 = n2 = this.ptr - this.wordStart;
        while (--n3 >= 0) {
            cArray[n + n3] = this.txt[this.wordStart + n3];
        }
    }

    public char[] getTokenChars() {
        int n;
        if (this.ptr > this.txtLength) {
            this.ptr = this.txtLength;
        }
        if ((n = this.ptr - this.wordStart) <= 0) {
            return null;
        }
        char[] cArray = new char[n];
        int n2 = n;
        while (--n2 >= 0) {
            cArray[n2] = this.txt[this.wordStart + n2];
        }
        return cArray;
    }

    public int getTokenOffset() {
        return this.wordStart;
    }

    public int getTokenLength() {
        return this.ptr - this.wordStart;
    }

    public boolean isAcceptingWildcards() {
        return this.acceptWildCards;
    }

    public void setAcceptingWildcards(boolean bl) {
        this.acceptWildCards = bl;
    }

    public boolean isParsingSpecialChars() {
        return this.parseSpecialChars;
    }

    public void setParsingSpecialChars(boolean bl) {
        this.parseSpecialChars = bl;
    }

    public void defineSpecialChar(char c) {
        if (this.specialChars == null) {
            this.specialChars = new IntSet(c);
        } else {
            this.specialChars.add(c);
        }
    }

    public boolean gotWildcard() {
        return this.gotWildCard;
    }

    public int nextToken() {
        this.gotWildCard = false;
        this.wordStart = this.ptr;
        while (this.ptr < this.txtLength) {
            this.wordStart = this.ptr;
            char c = this.txt[this.ptr];
            if (Character.isLetter(c) || this.testWildcard(c)) {
                int n = 0;
                ++this.ptr;
                while (this.ptr < this.txtLength) {
                    c = this.txt[this.ptr];
                    if (c == '\\' && this.acceptWildCards && this.ptr < this.txtLength) {
                        this.ptr += 2;
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        ++this.ptr;
                        continue;
                    }
                    if (Character.isDigit(c)) {
                        ++this.ptr;
                        ++n;
                        continue;
                    }
                    if (!this.testWildcard(c)) break;
                    ++this.ptr;
                }
                if (n <= this.maxDigit) {
                    return 1;
                }
            } else {
                if (Character.isDigit(c)) {
                    ++this.ptr;
                    while (this.ptr < this.txtLength && (Character.isDigit(c = this.txt[this.ptr]) || this.testWildcard(c))) {
                        ++this.ptr;
                    }
                    return 1;
                }
                if (this.parseSpecialChars && this.specialChars != null && this.specialChars.test(c)) {
                    ++this.ptr;
                    return c;
                }
                if (c == '\\' && this.acceptWildCards && this.ptr < this.txtLength) {
                    ++this.ptr;
                }
            }
            ++this.ptr;
        }
        this.wordStart = this.ptr;
        return 0;
    }

    protected boolean testWildcard(char c) {
        if (!this.acceptWildCards) {
            return false;
        }
        if (c != '.') {
            return false;
        }
        char c2 = this.charAhead(1);
        if (c2 == '?' || c2 == '+' || c2 == '*') {
            this.ptr += 2;
        } else if (c2 == '{') {
            String string;
            int n;
            for (n = this.ptr + 1; n < this.txtLength && this.txt[n] != '}'; ++n) {
            }
            if (n >= this.txtLength || this.txt[n] != '}') {
                this.ptr = n;
                throw new PatternSyntaxException("missing closing '}'", new String(this.txt), this.txtLength);
            }
            if (this.rangePattern == null) {
                this.rangePattern = new RegexMatchPattern(Pattern.compile("\\d+,\\d+?"));
            }
            if (!this.rangePattern.matches(string = new String(this.txt, this.ptr + 2, n - this.ptr - 2))) {
                throw new PatternSyntaxException("invalid wildcard repeat range", string, 0);
            }
            this.ptr = n;
        } else {
            ++this.ptr;
        }
        this.gotWildCard = true;
        return true;
    }

    protected char charAhead(int n) {
        int n2 = this.ptr + n;
        return n2 < 0 || n2 >= this.txtLength ? (char)'\u0000' : this.txt[n2];
    }

    public int getDigitMax() {
        return this.maxDigit;
    }

    public void setDigitMax(int n) {
        this.maxDigit = n;
    }
}

