/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.text;

import com.qizx.api.DataModelException;
import com.qizx.api.Indexing;
import com.qizx.api.util.text.SieveBase;
import com.qizx.util.basic.Util;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class FormatNumberSieve
extends SieveBase
implements Indexing.NumberSieve {
    public static final String FORMAT = "format";
    public static final String LOCALE = "locale";
    private NumberFormat format;
    private transient ParsePosition position = new ParsePosition(0);

    public FormatNumberSieve() {
        this.format = new DecimalFormat("############.##", new DecimalFormatSymbols(Locale.US));
        this.format.setMinimumFractionDigits(0);
        this.format.setParseIntegerOnly(false);
    }

    public FormatNumberSieve(String string) {
        this.format = new DecimalFormat(string);
        this.format.setMinimumFractionDigits(0);
        this.format.setParseIntegerOnly(false);
    }

    public void setParameters(String[] stringArray) throws DataModelException {
        this.parameters = stringArray;
        Locale locale = null;
        String string = null;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            if (FORMAT.equalsIgnoreCase(string2)) {
                string = stringArray[i + 1];
                continue;
            }
            if (LOCALE.equals(string2)) {
                locale = Util.getLocale(string3);
                continue;
            }
            throw new DataModelException("invalid sieve parameter " + string2);
        }
        if (string != null) {
            this.setFormat(string, locale);
        } else if (this.format == null) {
            throw new DataModelException("format parameter required");
        }
    }

    public void setFormat(String string, Locale locale) {
        this.format = locale == null ? new DecimalFormat(string) : new DecimalFormat(string, new DecimalFormatSymbols(locale));
        this.format.setParseIntegerOnly(false);
        this.addParameter(FORMAT, string);
    }

    public String getFormat() {
        return this.format instanceof DecimalFormat ? ((DecimalFormat)this.format).toPattern() : "";
    }

    public synchronized double convert(String string) {
        this.position.setIndex(0);
        Number number = this.format.parse(string, this.position);
        int n = this.position.getIndex();
        if (number == null) {
            return Double.NaN;
        }
        if (n < string.length() && !Character.isWhitespace(string.charAt(n))) {
            return Double.NaN;
        }
        return number.doubleValue();
    }
}

